# removeIPWhiteList {#removeipwhitelist}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`removeIPWhiteList(ips)`

## Arguments {#arguments}

**ips** is a STRING or IPADDR scalar/vector indicating one or more IP addresses.

## Details {#details}

Remove IP addresses from the whitelist. The whitelist feature is disabled when all IP addresses have been removed.

This function can only be executed by an administrator and takes effect on the cluster.

## Examples {#examples}

``` {#codeblock_zq1_tms_c2c}
addIPWhiteList(["1.1.1.1", "2.2.2.2", "3.3.3.3"])
removeIPWhiteList("2.2.2.2")
getIPWhiteList()
// output: ["1.1.1.1", "3.3.3.3"]
```

Related functions: [addIPWhiteList](../a/addipwhitelist.md), [getIPWhiteList](../g/getipwhitelist.md)

