# removeIPBlackList {#removeipblacklist}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`removeIPBlackList(ips)`

## Arguments {#arguments}

**ips** is a STRING or IPADDR scalar/vector indicating one or more IP addresses.

## Details {#details}

Remove IP addresses from the blacklist. The blacklist feature is disabled when all IP addresses have been removed.

This function can only be executed by an administrator and takes effect on the cluster.

## Examples {#examples}

``` {#codeblock_zq1_tms_c2c}
addIPBlackList(["1.1.1.1", "2.2.2.2", "3.3.3.3"])
removeIPBlackList("2.2.2.2")
getIPBlackList()
// output: ["1.1.1.1", "3.3.3.3"]
```

Related functions: [addIPBlackList](../a/addipblacklist.md), [getIPBlackList](../g/getipblacklist.md)

