# removeNode {#removeNode}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`removeNode(alias, [force=false])`

## Details {#details}

\[Linux Only\] Remove compute nodes from a cluster. It can only be executed by an administrator.

## Arguments {#arguments}

**alias** is a STRING scalar or vector indicating the node alias\(es\).

**force** \(optional\) is a BOOL scalar indicating whether to forcibly remove the nodes.

-   false \(default\): Nodes will only be removed if they are shut down.

-   true: Nodes will be forcibly shut down by the system and then removed. This may cause running tasks on the nodes to terminate.


## Examples {#examples}

Remove a compute node "cnode1". The node must be shut down before removal:

``` {#codeblock_dvn_rjs_xbc}
removeNode(alias="cnode1")
```

Force remove the compute nodes "cnode2" and "cnode3":

``` {#codeblock_u2n_5js_xbc}
removeNode(alias=`cnode2`cnode3, force=true)
```

