# registerStreamingSQL {#registerStreamingSQL}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`registerStreamingSQL(query, [queryId], [logTableCacheSize])`

## Arguments {#arguments}

**query** A STRING scalar representing the query for registering streaming SQL.

**queryId** \(optional\) A STRING scalar representing the ID name for *query*. Must follow variable naming rules: letters, numbers, or underscores only, and start with a letter.

-   If the specified *queryId* already exists, the system automatically appends a timestamp to create a unique ID.
-   If not specified, the system automatically generates a unique ID.

**logTableCacheSize** \(optional\) A positive integer indicating the maximum number of result change logs cached in memory. All logs are cached by default. Data in the cache that has not been published is retained as long as there are subscriptions. Published data is cleared according to the following rules:

-   If the number of logs inserted at a time does not exceed *logTableCacheSize*, old data is cleared when the total in-memory logs reach *logTableCacheSize* \* 2.
-   If the number of logs inserted at a time does exceeds *logTableCacheSize*, old data is cleared when the total in-memory logs reach \(inserted rows + *logTableCacheSize*\) \* 1.2.

## Details {#details}

The function registers a streaming SQL query and returns a unique queryId. Then the system generates a shared stream table with the same name as queryId to write result change logs.

**Return value**: A STRING scalar.

## Examples {#examples}

``` {#codeblock_y55_32x_mgc}
t=table(1..10 as id,rand(100,10) as val)
share t as st
declareStreamingSQLTable(st)
registerStreamingSQL("select avg(val) from st","sql_avg")

// Get the status of streaming SQL query
getStreamingSQLStatus("sql_avg")
```

**Related functions:** [declareStreamingSQLTable](../d/declareStreamingSQLTable.md), [registerStreamingSQL](registerStreamingSQL.md)

