# regexCount {#regexcount}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`regexCount(str, pattern, [offset=0])`

## Arguments {#topic_pby_vy5_3zb}

**str** is a string or a string vector.

**pattern** is an ordinary string scalar or a regular expression pattern to be searched in *str*. Regular expression pattern includes character literals, metacharacters, or a combination of both.

**offset** \(optional\) is a non-negative integer with default value of 0. This optional argument is the starting position in *str* to conduct the count operation. The first character in *str* corresponds to position 0.

## Details {#details}

Search in *str* from the *offset* position, and return an integer indicating how many times a string that matches *pattern* occurs in *str*.

## Examples {#examples}

```
regexCount("1231hsdU777_ DW#122ddd", "[0-9]+");
// output: 3

regexCount("1231hsdU777_ DW#122ddd", "[0-9]+$");
// output: 0

regexCount("1231hsdU777_ DW#122ddd", "^[0-9]+");
// output: 1

regexCount("abc234 ff456", "[a-z]", 3);
// output: 2
```

