# rebalanceChunksWithinDataNode {#rebalancechunkswithindatanode}

## Syntax {#syntax}

`rebalanceChunksWithinDataNode(nodeAlias, [exec = false], [updatedBeforeDays = 7.0])`

## Arguments {#arguments}

**nodeAlias** is a string indicating the alias of a node.

**exec** \(optional\) is a Boolean value indicating whether to initiate data rebalancing within a data node. The default value is false, meaning that data rebalancing will not be executed and only the rebalancing plan will be returned.

**updatedBeforeDays** \(optional\) is a non-negative floating-point number, which limits the rebalancing process to only include chunks that were updated before *updatedBeforeDays*. The default value is 7 \(in days\).

## Details {#details}

After volumes are added in a data node, partitions on the other volumes need to be rebalanced for optimal performance. This function is used to rebalance data among volumes within a data node. It can only be executed on a controller by an administrator in cluster mode.

Starting from 2.00.12, `rebalanceChunksWithinDataNode` is supported in the standalone mode.

Return a table containing the following columns:

|name|meaning|
|----|-------|
|chunkId|the chunk ID|
|srcVolume|source volume|
|destVolume|destination volume|

You can get the status of recovery tasks by [getRecoveryTaskStatus](../g/getRecoveryTaskStatus.md) on a controller.

## Examples {#examples}

```
rebalanceChunksWithinDataNode("node1")
```

|ChunkId|srcVolume|destVolume|
|-------|---------|----------|
|82c6eb6c-36ee-b1b6-4a86-ca24d9faaa25|/hdd/hdd1/volumes|/hdd/hdd2/volumes|

