# readRecord! {#readrecord}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`readRecord!(handle, holder, [offset=0], [length])`

## Arguments {#arguments}

**handle** is a binary file handle.

**holder** is a table or a tuple with array elements of equal size.

**offset** \(optional\) specifies the starting row position.

**length** \(optional\) indicates the number of rows to be loaded.

## Details {#details}

Convert binary files to DolphinDB data objects. DolhinDB also provides the function [writeRecord](../w/writeRecord.md) to covert DolphinDB data objects to binary files that can be used by other programs. The binary files should be row-based and each row should contain records with fixed data types and lengths. For example, if a binary file contains 5 data fields with the following type \(length\): char\(1\), boolean\(1\), short\(2\), int\(4\), long\(8\), and double\(8\), the function `readRecord!` will treat every 24 bytes as a new row. Similarly, the function `writeRecord` converts DolphinDB objects such as tables or tuples to binary files with the aforementioned format.

## Examples {#examples}

```
// create a file handle for reading records. The binary file a.bin contains 1000 records
f=file("c:/DB/a.bin")
t=table(1000:0, `PERMNO`PRC`VOL`SHROUT, `int`double`int`double)
f.readRecord!(t);
// output: 1000

// similarily, we can load a binary file to a DolphinDB tuple object
f=file("c:/DB/a.bin")
t=loop(array, [int, double, int, double], 0, 500)
// create tuple t with 4 array elements. The size of each array is 500.
 f.readRecord!(t, 0, 500);
// read the first 500 rows
// output: 500
```

