# readLines {#readlines}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`readLines(handle, [length=1024])`

## Arguments {#arguments}

**handle** is the handle of the file to read.

**length** \(optional\) is the number of lines from the handle to read. The default number of lines to read is 1024.

## Details {#details}

Read a given number of lines from the handle. The function returns if the handle reaches the end or the given number of lines has been read.

## Examples {#examples}

```
timer(10){
x=rand(`IBM`MSFT`GOOG`YHOO`ORCL,10240)
eachRight(writeLine, file("test.txt","w"),x)
fin = file("test.txt")
do{
   y=fin.readLine()
} while(!y.isVoid())
fin.close()
};
// Time elapsed 277.548 ms ms


timer(10){
x=rand(`IBM`MSFT`GOOG`YHOO`ORCL,10240)
file("test.txt","w").writeLines(x)
fin = file("test.txt")
do{
   y=fin.readLines(1024)
} while(y.size()==1024)
 fin.close()
};
// Time elapsed 28.003 ms
```

