# readLines! {#readlines}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`readLines!(handle, holder, [offset=0], [length=1])`

## Arguments {#arguments}

**handle** is the handle of the file to read.

**holder** is the variable that saves the data that are imported into the system.

**offset** \(optional\) is the starting position of the holder to save the lines.

**length** \(optional\) is the number of lines to read.

## Details {#details}

Read a number of lines from the handle and save them to holder starting from the given offset, and return the number of lines read.

The [readLines](readLines.md) function returns a string vector for every call. It takes a certain amount of time to create a string vector, so it saves time if we can reuse the same vector as the buffer when a function call repeats. `readLines!` is such a function that accepts the existing buffer as data holder. The 2 examples below read the same amount of data for 100 times. It is faster to use `readLines!` than `readLines` .

## Examples {#examples}

```
timer(100){
fin = file("test.txt")
do{ y=fin.readLines(1024) } while(y.size()==1024)
fin.close()
};
// Time elapsed: 79.511 ms

timer(100){
fin = file("test.txt")
y=array(STRING,1024)
do{ lines = fin.readLines!(y,0,1024) } while(lines==1024)
fin.close()
};
// Time elapsed: 56.034 ms
```

