# read! {#read}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`read!(handle, holder, [offset=0], [length=1])`

## Arguments {#arguments}

**handle** is the handle of the file to read.

**holder** is the variable that saves the data that are imported into the system.

**offset** is the starting position of the holder to save the data.

**length** is the number of data points to read.

## Details {#details}

Read a given number of data points from the handle and save them to the holder starting from the given offset, and return the number of data points read. The type of data to read is the same as the type of the holder.

The [readBytes](readBytes.md) function always returns a new CHAR vector. It takes some time to create a new vector buffer. To improve the performance, we can create a buffer and reuse it. `read!` is such a function that accepts an existing buffer.Another advantage of the `read!` function is that we don't need to know the exact number of bytes to read. The function returns if it reaches the end of the file or if the give number of bytes have been read. If the returned count is less than expected, it indicates the file has reached the end.

## Examples {#examples}

This example defines a function to copy a file:

```
def fileCopy(source, target){
s = file(source)
t = file(target,"w")
buf = array(CHAR,1024)
do{
  numByte = s.read!(buf,0,1024)
  t.write(buf,0, numByte)
}while(numByte==1024)
}
fileCopy("test.txt","testcopy.txt");
```

