# ratio {#ratio}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`ratio(X, Y)` or `X\Y`

## Arguments {#arguments}

**X** and **Y** is a scalar/pair/vector/matrix.

If *X* or *Y* is a pair/vector/matrix, the other is a scalar or a pair/vector/matrix of the same size.

## Details {#details}

Returns element-by-element ratio of *X* to *Y*. Function `ratio` always returns floating numbers. If both *X* and *Y* are integer/long, `ratio` converts them into floating numbers and then conduct division. This is different from operator [div](../d/div.md) \(/\) , which does not convert integer/long to floating numbers. Another difference with `div` is that *Y* can be negative integers when *X* is integer.

## Examples {#examples}

```
9\2:5;
// output: 4.5 : 1.8

11:25\3:4;
// output: 3.666667 : 6.25

x=1 2 3;
x \ 2;
// output: [0.5,1,1.5]

2 \ x;
// output: [2,1,0.666667]

y=4 5 6;
 x \ y;
// output: [0.25,0.4,0.5]

y \ x;
// output: [4,2.5,2]

m1=1..6$2:3;
m1
```

|\#0|\#1|\#2|
|---|---|---|
|1|3|5|
|2|4|6|

```
 m1\2;
```

|\#0|\#1|\#2|
|---|---|---|
|0.5|1.5|2.5|
|1|2|3|

```
m2=6..1$2:3;
m2
```

|\#0|\#1|\#2|
|---|---|---|
|6|4|2|
|5|3|1|

```
m1\m2;
```

|\#0|\#1|\#2|
|---|---|---|
|0.166667|0.75|2.5|
|0.4|1.333333|6S|

```
-7\5;
// output: -1.4

x=-1 2 3;
x\-5;
// output: [0.2,-0.4,-0.6]
```

