# rand {#rand}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`rand(X, [count])`

## Arguments {#arguments}

**X** is a scalar/vector.

**count**\(optional\) is an INT scalar/pair.

-   If *count* is not specified, a scalar is returned.
-   If *count* is a scalar, it specifies the length of the output vector.
-   If *count* is a tuple, it specifies the dimensions of the output matrix.

## Details {#details}

Return a random scalar/vector/matrix of the same data type as *X*.

-   If *X* is a scalar, *X* must be a positive numerical value. Random values are generated following a uniform distribution on \[0, *X*\).
-   If *X* is a vector, random values are drawn from the elements of *X*.

## Examples {#examples}

```
// generate a random scalar (without specifying count)
rand(2)
// output: 0
rand(1 2 5)
// output: 1

// generate 20 random non-negative integers less than 10
rand(10, 20);
// output: [9,9,8,1,1,0,8,3,2,6,4,6,9,6,8,9,3,2,1,5]

// generate 10 random non-negative double values less than 9.8
rand(9.8, 10);// output: [3.653754,1.750518,0.055747,5.219222,2.473778,6.337576,7.797493,1.392241,0.149499,5.697612]

// generate 3 random values drawn from vector x
x=3 5 4 6 9;
rand(x, 3);
// output: [9,3,6]

// generate a 2*2 random matrix less than 10
rand(10.0, 2:2) 
```

|col1|col2|
|----|----|
|0.8233|1.0052|
|7.1127|9.7578|

```
12:35:06 + rand(100, 10);
// output: [12:35:44,12:35:16,12:35:50,12:35:44,12:35:46,12:35:09,12:35:50,12:36:35,12:35:09,12:36:44]

x=`IBM`C`AAPL`BABA;
rand(x, 10);
// output: ["IBM","BABA","C","AAPL","IBM","C","BABA","AAPL","BABA","BABA"]
```

``` {#codeblock_qxd_mjb_bbc}
rand(x,2:3)
```

|\#0|\#1|\#2|
|---|---|---|
|BABA|AAPL|BABA|
|C|AAPL|AAPL|

