# quarterBegin {#quarterbegin}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`quarterBegin(X, [startingMonth=1], [offset], [n=1])`

## Arguments {#arguments}

**X** is a scalar/vector of data type DATE, DATEHOUR, DATETIME, TIMESTAMP or NANOTIMESTAMP.

**startingMonth** is an integer between 1 and 12 indicating a month. The default value is 1.

**offset** is a scalar of the same data type as *X*. It must be no greater than the minimum value of *X*. The default value is the minimum value of *X*.

**n** is a positive integer. The default value is 1.

## Details {#details}

Return the first day of the quarter that *X* belongs to. The first months of the quarters are determined by *startingMonth*. Note that *startingMonth*=1 is equivalent to *startingMonth*=4, 7 or 10.

If parameter *offset* is specified, the result is updated every *n* quarters. The parameters *offset* and *n* must be specified together, and *offset* takes effect only when *n* &gt; 1.

## Examples {#examples}

```
quarterBegin(2012.06.12);
// output: 2012.04.01

quarterBegin(2012.06.13 10:10:10.008,5);
// output: 2012.05.01

date=2016.01.12 2016.02.25 2016.05.12 2016.06.28 2016.07.10 2016.08.18 2016.09.02 2016.10.16 2016.11.26 2016.12.30
time = [09:34:07,09:36:42,09:36:51,09:36:59,09:32:47,09:35:26,09:34:16,09:34:26,09:38:12,09:38:13]
sym = take(`MSFT,10)
price= 49.6 29.46 29.52 30.02 174.97 175.23 50.76 50.32 51.29 52.38
qty = 2200 1900 2100 3200 6800 5400 1300 2500 8800 4500
t1 = table(date, time, sym, qty, price);

select avg(price),sum(qty) from t1 group by quarterBegin(date,1,2016.01.01,2)
```

|quarterBegin\_date|avg\_price|sum\_qty|
|------------------|----------|--------|
|2016.01.01|34.65|9400|
|2016.07.01|92.491667|29300|

Related functions: [quarterEnd](quarterEnd.md), [businessQuarterBegin](../b/businessQuarterBegin.md), [businessQuarterEnd](../b/businessQuarterEnd.md)

