# quantileSeries {#quantileseries}

## Syntax {#syntax}

`quantileSeries(X, q, [interpolation='linear'])`

## Arguments {#arguments}

**X** is a numeric vector.

**q** is a scalar or vector of floating numbers between 0 and 1.

**interpolation** is a string indicating how to interpolate if the quantile is between element i and j in X with i&lt;j. It can take the following values and the default value is 'linear'.

-   'linear' \(default\): i+\(j-i\)\*fraction, where fraction is the decimal part of *q*\*size\(X\).

-   'lower': i

-   'higher': j

-   'nearest': i or j whichever is nearest.

-   'midpoint': \(i+ j\)/2


## Details {#details}

Return values at the given quantile in *X*.

## Examples {#examples}

```
a=[6, 47, 49, 15, 42, 41, 7, 39, 43, 40, 36];
quantileSeries(a,[0.25,0.5,0.75]);
// output: [25.5,40,42.5]

quantileSeries(a,[0.25,0.5,0.75], 'higher');
// output: [36,40,43]
```

Related function: [quantile](quantile.md)

