# purgeStreamGraphRecords {#purgeStreamGraphRecords}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`purgeStreamGraphRecords(name)`

## Arguments {#arguments}

**name** is a string representing the name of the stream graph. You can provide either the fully qualified name \(FQN\), such as "catalog\_name.orca\_graph.graph\_name", or just the graph name, like "factors". If only the name is given, the system will automatically complete it using the current catalog.

## Details {#details}

Deletes the metadata record of the specified stream graph from the DFS table. This operation is only allowed if the stream graph’s status is "destroyed"; otherwise, an exception will be thrown.

In a cluster deployment, this function can only be run by an administrator or a user who has the COMPUTE\_GROUP\_EXEC permission for the compute group used when the stream graph was created. In a single-node deployment, no permission check is required.

## Examples {#examples}

After using [dropStreamGraph](../d/dropStreamGraph.md) to destroy a stream graph, you can remove its record as follows:

``` {#codeblock_zq1_tms_c2c}
purgeStreamGraphRecords("demo.orca_graph.indicators")
getStreamGraphMeta("demo.orca_graph.indicators")["status"]

/*
id fqn status semantics checkpointConfig tasks createTime owner reason
-- --- ------ --------- ---------------- ----- ---------- ----- ------
*/
```

