# prod {#prod}

## Syntax {#syntax}

`prod(X)`

## Arguments {#arguments}

**X** is a scalar/vector/matrix/table.

## Details {#details}

If *X* is a vector, return the product of all the elements in *X*.

If *X* is a matrix, calculate the product of all the elements in each column of *X* and return a vector.

If *X* is a table, calculate the product of all the elements in each column of *X* and return a table.

As with all aggregate functions, null values are not included in the calculation.

## Examples {#examples}

```
prod(1 2 NULL 3);
// output: 6
```

```
m=matrix(1 2 3, 4 5 6);
m;
```

|\#0|\#1|
|---|---|
|1|4|
|2|5|
|3|6|

```
prod(m);
// output: [6,120]
```

