# point {#point}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`point(X, Y)`

## Arguments {#arguments}

**X** and **Y** are numeric scalars, pairs, vectors or matrices. They can be of integral \(compress or INT128 not included\) or floating type.

## Details {#details}

Generate a POINT type data to store the location of a midpoint in the coordinate system.

The length of a POINT type is 16 bytes. The low 8 bytes are stored in *X* and the high 8 bytes are stored in *Y*.

## Examples {#examples}

```
point(117.60972, 24.118418)
// output: (117.60972, 24.118418)

point(1..5,6..10)
```

|0|1|2|3|4|
|---|---|---|---|---|
|\(1.0, 6.0\)|\(2.0, 7.0\)|\(3.0, 8.0\)|\(4.0, 9.0\)|\(5.0, 10.0\)|

Related functions: [highDouble](../h/highDouble.md), [lowDouble](../l/lowDouble.md)

