# pinverse {#pinverse}

## Syntax {#Syntax .section}

`pinverse(X)`

## Arguments {#Arguments .section}

**X** is a matrix.

## Details {#Details .section}

Calculate the pseudo-inverse matrix of *X*.

**Return Value**: a FAST DOUBLE MATRIX

## Example {#Example .section}

``` {#codeblock_j5z_wwr_z1c}
x=1..4$2:2;
x.pinverse()
```

<table id="table_nqs_twr_z1c"><thead><tr><th>

col1

</th><th>

col2

</th></tr></thead><tbody><tr><td>

-2

</td><td>

1.5

</td></tr><tr><td>

1

</td><td>

-0.5

</td></tr></tbody>
</table>``` {#codeblock_dr2_zwr_z1c}
y=1..8$2:4
y.pinverse(); 
```

<table id="table_qqs_twr_z1c"><thead><tr><th>

col1

</th><th>

col2

</th></tr></thead><tbody><tr><td>

-1

</td><td>

0.85

</td></tr><tr><td>

-0.5

</td><td>

0.45

</td></tr><tr><td>

0

</td><td>

0.05

</td></tr><tr><td>

0.5

</td><td>

-0.35

</td></tr></tbody>
</table>``` {#codeblock_tqs_twr_z1c}
s1 = indexedSeries(2012.01.01..2012.01.04, [10, 20, 30, 40])
pinv(s1)
```

<table id="table_uqs_twr_z1c"><thead><tr><th>

col1

</th><th>

col2

</th><th>

col3

</th><th>

col4

</th></tr></thead><tbody><tr><td>

0.0033

</td><td>

0.0067

</td><td>

0.01

</td><td>

0.0133

</td></tr></tbody>
</table>``` {#codeblock_imt_bxr_z1c}
m=matrix(1..10, 11..20)
m.rename!(2020.01.01..2020.01.10, `A`B);
m.setIndexedMatrix!()
pinv(m)
```

<table id="table_zqs_twr_z1c"><thead><tr><th>

col1

</th><th>

col2

</th><th>

col3

</th><th>

col4

</th><th>

col5

</th><th>

col6

</th><th>

col7

</th><th>

col8

</th><th>

col9

</th><th>

col10

</th></tr></thead><tbody><tr><td>

-0.0945

</td><td>

-0.0758

</td><td>

-0.057

</td><td>

-0.0382

</td><td>

-0.0194

</td><td>

-0.0006

</td><td>

0.0182

</td><td>

0.037

</td><td>

0.0558

</td><td>

0.0745

</td></tr><tr><td>

0.04

</td><td>

0.0333

</td><td>

0.0267

</td><td>

0.02

</td><td>

0.0133

</td><td>

0.0067

</td><td>

0

</td><td>

-0.0067

</td><td>

-0.0133

</td><td>

-0.02

</td></tr></tbody>
</table>For a matrix without a full rank, calculating the inverse will raise an error. The pseudo inverse can be calculated.

``` {#codeblock_krs_twr_z1c}
x=1 2 3 1 2 3$2:3
inverse(x) // Error: The argument of 'inverse' must be a square matrix.
pinverse(x)
```

|col1|col2|
|----|----|
|-0.1067|0.2267|
|0.4133|-0.2533|
|-0.0667|0.2667|

Related function: [inverse](../i/inverse.md)

**Parent topic:**[Functions](../../Functions/category.md)

