# percentChange {#percentchange}

## Syntax {#syntax}

`percentChange(X, [n])`

## Arguments {#arguments}

**X** is a vector or matrix.

**n** \(optional\) is an integer specifying the step to shift when comparing elements in *X*. The default value is 1, meaning to compare the current element with the adjacent element at left.

## Details {#details}

For each element *Xi* in *X*, return *\(Xi/ Xi-n\) - 1*, representing the percentage changes between elements.

**Return value**: A vector or matrix with the same shape as *X*.

## Examples {#examples}

```
percentChange([1,2,3]);
// output: [,1,0.5]

percentChange(85 90 95);
// output: [,0.058824,0.055556]
```

```
m=matrix(100 105 109 112 108 116, 200 212 208 199 206 210);
m
```

|\#0|\#1|
|---|---|
|100|200|
|105|212|
|109|208|
|112|199|
|108|206|
|116|210|

```
percentChange(m);
```

|\#0|\#1|
|---|---|
|||
|0.05|0.06|
|0.038095238095238|-0.018867924528302|
|0.027522935779817|-0.043269230769231|
|-0.035714285714286|0.035175879396985|
|0.074074074074074|0.019417475728155|

When *n*is positive:

``` {#codeblock_l4p_yhd_2bc}
r = percentChange(1..10,3);
r;
// output: [,,,3,1.5,1,0.75,0.6,0.5,0.43]
```

``` {#codeblock_p43_xhd_2bc}
m=matrix(1 3 2 NULL 6 9 3, 0 8 NULL 7 6 2 8);
r = percentChange(m,2);
r;
```

|0|1|
|---|---|
|||
|||
|1||
||-0.13|
|2||
||-0.71|
|-0.5|0.33|

When *n*is negative:

``` {#codeblock_tnm_13d_2bc}
m = 3 4 6 9
r2= percentChange(m,-2)
r2; 
// output: [-0.5,-0.56,,]
```

