# pdfNormal {#pdfNormal}

## Syntax {#Syntax.2 .section}

`pdfNormal(mean, stdev, X)`

## Arguments {#Arguments.2 .section}

**mean** is a numeric scalar representing the mean of the normal distribution.

**stdev** is a numeric scalar representing the standard deviation of the normal distribution.

**X** is a numeric scalar or vector representing the points at which to compute the probability density.

## Details {#Details.2 .section}

Calculate the probability density of the specified normal distribution at *X*.

Its functionality and usage are the same as `scipy.stats.norm.pdf`.

## Examples {#Examples.2 .section}

Calculate the probability density value of the standard normal distribution at *X*=1:

``` {#codeblock_yzn_2rr_z1c}
pdfNormal(mean=0, stdev=1, X=1)
// output: 0.24197072451914337
```

Calculate the probability density values of a normal distribution with mean 1 and variance 1.5 at *X*=1, 2, 3:

``` {#codeblock_gvk_crr_z1c}
pdfNormal(mean=1, stdev=1.5, X=[1,2,3])
// output: [0.265961520267622,0.212965337014901,0.109340049783996]
```

**Parent topic:**[Functions](../../Functions/category.md)

