# parseMktData {#parseMktData}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`parseMktData(dict)`

## Arguments {#arguments}

**dict** A dictionary or a STRING scalar representing a JSON-encoded dictionary that defines the market data to be parsed.

## Details {#details}

Parses the given dictionary or JSON string into MKTDATA type.

**Return value**: A MKTDATA object.

## Supported Market Data and Fields {#topic_y2j_3sq_ngc}

The MKTDATA type is newly introduced in DolphinDB version 3.00.4, which provides database support for the market data used for pricing.

Currently supported types:

-   **Spot prices:** FxSpot \(foreign exchange spot rate\)

-   **Term structure curves:** IrYieldCurve \(interest rate yield curve\), AssetPriceCurve \(asset price curve\)

-   **Volatility surfaces:** FxVolatilitySurface \(foreign exchange volatility surface\)


### FxSpot {#topic_cgm_jsq_ngc}

<table id="table_ydf_ksq_ngc"><thead><tr><th>

Field Name

</th><th>

Data Type

</th><th>

Description

</th><th>

Required

</th></tr></thead><tbody><tr><td>

mktDataType

</td><td>

STRING

</td><td>

Must be "Spot"

</td><td>

√

</td></tr><tr><td>

referenceDate

</td><td>

DATE

</td><td>

Reference Date

</td><td>

√

</td></tr><tr><td>

version

</td><td>

INT

</td><td>

Version, default 0

</td><td>

×

</td></tr><tr><td>

spotDate

</td><td>

DATE

</td><td>

Spot settlement date. Use internal static data by default.

</td><td>

×

</td></tr><tr><td>

spotType

</td><td>

STRING

</td><td>

Spot price type. Must be "FxSpot"

</td><td>

√

</td></tr><tr><td>

value

</td><td>

DOUBLE

</td><td>

Spot price

</td><td>

√

</td></tr><tr><td>

unit

</td><td>

STRING

</td><td>

Unit for spot prices. Available options: "EURUSD", "USDCNY", "EURCNY", "GBPCNY", "JPYCNY", "HKDCNY".

 Currency pairs may also use `.` or `/` as separators. For example, "EURUSD" can also be written as "EUR.USD" or "EUR/USD".

</td><td>

√

</td></tr></tbody>
</table>Define a MKTDATA object of FxSpot type.

``` {#codeblock_d2f_ksq_ngc}
fxSpot = {
    "mktDataType": "Spot",
    "referenceDate": 2025.08.18,
    "version": 0, 
    "spotDate": 2025.08.20,
    "spotType": "FxSpot",
    "value": 7.2659,
    "unit": "USDCNY"
}

mktData = parseMktData(fxSpot)
print(mktData)
```

### IrYieldCurve {#topic_ccr_msq_ngc}

<table id="table_usm_nsq_ngc"><thead><tr><th>

Field Name

</th><th>

Data Type

</th><th>

Description

</th><th>

Required

</th></tr></thead><tbody><tr><td>

mktDataType

</td><td>

STRING

</td><td>

Must be "Curve"

</td><td>

√

</td></tr><tr><td>

referenceDate

</td><td>

DATE

</td><td>

Reference Date

</td><td>

√

</td></tr><tr><td>

version

</td><td>

INT

</td><td>

Version, default 0

</td><td>

×

</td></tr><tr><td>

curveType

</td><td>

STRING

</td><td>

Must be "IrYieldCurve"

</td><td>

√

</td></tr><tr><td>

dayCountConvention

</td><td>

STRING

</td><td>

The day count convention to use. It can be:

 -   "Actual360": actual/360

-   "Actual365": actual/365

-   "ActualActualISMA": actual/actual according to ISMA \(International Securities Market Association\) convention

-   "ActualActualISDA": actual/actual according to ISDA \(International Swaps and Derivatives Association\) convention.


</td><td>

√

</td></tr><tr><td>

interpMethod

</td><td>

STRING

</td><td>

Interpolation method. It can be:

 -   "Linear": linear interpolation

-   "CubicSpline": cubic spline interpolation

-   "CubicHermiteSpline": cubic Hermite interpolation


</td><td>

√

</td></tr><tr><td>

extrapMethod

</td><td>

STRING

</td><td>

Extrapolation method. It can be

 -   Flat: flat extrapolation

-   Linear: linear extrapolation


</td><td>

√

</td></tr><tr><td>

dates

</td><td>

DATE vector

</td><td>

Date of each data point

</td><td>

√

</td></tr><tr><td>

values

</td><td>

DOUBLE vector

</td><td>

Value of each data point, corresponding to the elements in dates.

</td><td>

√

</td></tr><tr><td>

curveName

</td><td>

STRING

</td><td>

Curve name

</td><td>

×

</td></tr><tr><td>

currency

</td><td>

STRING

</td><td>

Currency. It can be CNY", "USD", "EUR", "GBP", "JPY", "HKD"

</td><td>

√

</td></tr><tr><td>

compounding

</td><td>

STRING

</td><td>

The compounding interest. It can be:

 -   "Compounded": discrete compounding

-   "Simple": simple interest \(no compounding\).

-   "Continuous": continuous compounding.


</td><td>

√

</td></tr><tr><td>

settlement

</td><td>

DATE

</td><td>

Settlement date. If specified, all subsequent tenor intervals are computed starting from "settlement" rather than from "referenceDate".

</td><td>

×

</td></tr><tr><td>

frequency

</td><td>

INTEGRAL/STRING

</td><td>

The interest payment frequency. Supported values:

 -   -1 or "NoFrequency": No payment frequency

-   0 or "Once": Single lump-sum payment of principal and interest at maturity.

-   1 or "Annual": Annually

-   2 or "Semiannual": Semiannually

-   3 or "EveryFourthMonth": Every four months

-   4 or "Quarterly": Quarterly

-   6 or "BiMonthly": Every two months

-   12 or "Monthly": Monthly

-   13 or "EveryFourthWeek": Every four weeks

-   26 or "BiWeekly": Every two weeks

-   52 or "Weekly": Weekly

-   365 or "Daily": Daily

-   999 or "Other": Other frequencies


</td><td>

×

</td></tr><tr><td>

curveModel

</td><td>

STRING

</td><td>

Curve construction model; It can be "Bootstrap" \(default\), "NS", "NSS".

 When the value is "NSS" or "NS", the fields interpMethod, extrapMethod, dates, and values are not required.

</td><td>

×

</td></tr><tr><td>

curveParams

</td><td>

DICT

</td><td>

Model parameters. It is required when *curveModel*is "NSS" or "NS":

 -   If curveModel = "NS": must include keys 'beta0', 'beta1', 'beta2', 'lambda'.


 -   If curveModel = "NSS": must include keys 'beta0', ‘beta1', 'beta2', 'beta3', 'lambda0', 'lambda1'.


</td><td>

×

</td></tr></tbody>
</table>Define a MKTDATA object of IrYieldCurve type.

``` {#codeblock_gtm_nsq_ngc}
aod = 2025.07.01
curve = {
    "mktDataType": "Curve",
    "curveType": "IrYieldCurve",
    "version": 0, 
    "referenceDate": aod,
    "currency": "CNY",
    "dayCountConvention": "Actual365",
    "compounding": "Continuous",
    "interpMethod": "Linear",
    "extrapMethod": "Flat",
    "dates":[2025.07.07,2025.07.10,2025.07.17,2025.07.24,2025.08.04,2025.09.03,2025.10.09,2026.01.05,
        2026.04.03,2026.07.03,2027.01.04,2027.07.05,2028.07.03],
    "values":[0.015785,0.015931,0.016183,0.016381,0.016493,0.016503,0.016478,0.016234,0.016321,
        0.016378,0.015508,0.015185,0.014901],
    "settlement": aod+2
}

mktData = parseMktData(curve)
print(mktData)
```

## IrYieldCurve\(non-bond\) {#topic_s2n_gk1_4gc}

<table id="IrYieldCurve_nonBond"><thead><tr><th>

Field Name

</th><th>

Data Type

</th><th>

Description

</th><th>

Required

</th></tr></thead><tbody><tr><td>

mktDataType

</td><td>

STRING

</td><td>

Must be "Curve"

</td><td>

√

</td></tr><tr><td>

referenceDate

</td><td>

DATE

</td><td>

Reference Date

</td><td>

√

</td></tr><tr><td>

version

</td><td>

INT

</td><td>

Version, default 0

</td><td>

×

</td></tr><tr><td>

curveType

</td><td>

STRING

</td><td>

Must be "IrYieldCurve"

</td><td>

√

</td></tr><tr><td>

dayCountConvention

</td><td>

STRING

</td><td>

The day count convention to use. It can be:

 -   "Actual360": actual/360

-   "Actual365": actual/365

-   "ActualActualISMA": actual/actual according to ISMA \(International Securities Market Association\) convention

-   "ActualActualISDA": actual/actual according to ISDA \(International Swaps and Derivatives Association\) convention.


</td><td>

√

</td></tr><tr><td>

interpMethod

</td><td>

STRING

</td><td>

Interpolation method. It can be:

 -   "Linear": linear interpolation

-   "CubicSpline": cubic spline interpolation

-   "CubicHermiteSpline": cubic Hermite interpolation


</td><td>

√

</td></tr><tr><td>

extrapMethod

</td><td>

STRING

</td><td>

Extrapolation method. It can be

 -   Flat: flat extrapolation

-   Linear: linear extrapolation


</td><td>

√

</td></tr><tr><td>

dates

</td><td>

DATE vector

</td><td>

Date of each data point

</td><td>

√

</td></tr><tr><td>

values

</td><td>

DOUBLE vector

</td><td>

Value of each data point, corresponding to the elements in dates.

</td><td>

√

</td></tr><tr><td>

curveName

</td><td>

STRING

</td><td>

Curve name

</td><td>

×

</td></tr><tr><td>

currency

</td><td>

STRING

</td><td>

Currency. It can be CNY", "USD", "EUR", "GBP", "JPY", "HKD"

</td><td>

√

</td></tr><tr><td>

compounding

</td><td>

STRING

</td><td>

The compounding interest. It can be:

 -   "Compounded": discrete compounding

-   "Simple": simple interest \(no compounding\).

-   "Continuous": continuous compounding.


</td><td>

√

</td></tr><tr><td>

settlement

</td><td>

DATE

</td><td>

Settlement date. If specified, all subsequent tenor intervals are computed starting from "settlement" rather than from "referenceDate".

</td><td>

×

</td></tr><tr><td>

frequency

</td><td>

INTEGRAL/STRING

</td><td>

The interest payment frequency. Supported values:

 -   -1 or "NoFrequency": No payment frequency

-   0 or "Once": Single lump-sum payment of principal and interest at maturity.

-   1 or "Annual": Annually

-   2 or "Semiannual": Semiannually

-   3 or "EveryFourthMonth": Every four months

-   4 or "Quarterly": Quarterly

-   6 or "BiMonthly": Every two months

-   12 or "Monthly": Monthly

-   13 or "EveryFourthWeek": Every four weeks

-   26 or "BiWeekly": Every two weeks

-   52 or "Weekly": Weekly

-   365 or "Daily": Daily

-   999 or "Other": Other frequencies


</td><td>

×

</td></tr><tr><td>

curveModel

</td><td>

STRING

</td><td>

Curve construction model; Currently, only "Bootstrap" is supported.

</td><td>

×

</td></tr><tr><td>

curveParams

</td><td>

DICT

</td><td>

Model parameters.

</td><td>

×

</td></tr></tbody>
</table>### AssetPriceCurve {#topic_ocm_psq_ngc}

|Field Name|Data Type|Description|Required|
|----------|---------|-----------|--------|
|mktDataType|STRING|Must be "Curve"|√|
|referenceDate|DATE|Reference Date|√|
|version|INT|Version, default 0|×|
|curveType|STRING|Must be "AssetPriceCurve"|√|
|dates|DATE vector|Date of each data point|√|
|values|DOUBLE vector|Value of each data point, corresponding to the elements in dates.|√|
|curveName|STRING|Curve name|×|

Define a MKTDATA object of AssetPriceCurve type.

``` {#codeblock_tqb_rsq_ngc}
curve = {
    "mktDataType": "Curve",
    "curveType": "AssetPriceCurve",
    "version": 0, 
    "referenceDate": 2024.06.28,
    "curveName": "PRICE_SHIBOR_3M",
    "dates": [2024.06.21, 2024.06.24, 2024.06.25, 2024.06.26,2024.06.27],
    "values": [1.923, 1.922, 1.921, 1.919, 1.918]/100
}

mktData = parseMktData(curve)
print(mktData)
```

### FxVolatilitySurface {#topic_vhw_ssq_ngc}

<table id="table_lk1_5sq_ngc"><thead><tr><th>

Field Name

</th><th>

Data Type

</th><th>

Description

</th><th>

Required

</th></tr></thead><tbody><tr><td>

mktDataType

</td><td>

STRING

</td><td>

Must be "Surface"

</td><td>

√

</td></tr><tr><td>

referenceDate

</td><td>

DATE

</td><td>

Reference Date

</td><td>

√

</td></tr><tr><td>

version

</td><td>

INT

</td><td>

Version, default 0

</td><td>

×

</td></tr><tr><td>

surfaceType

</td><td>

STRING

</td><td>

Must be "FxVolatilitySurface"

</td><td>

√

</td></tr><tr><td>

smileMethod

</td><td>

STRING

</td><td>

Volatility smile method. It can be:

 -   "Linear": linear smile

-   "CubicSpline": cubic-spline smile

-   "SVI": SVI-model smile

-   "SABR": SABR-model smile


</td><td>

√

</td></tr><tr><td>

volSmiles

</td><td>

DICT\(STRING, ANY\)vector

</td><td>

Volatility smiles vector. Each element is one smile . It has the following members:

 -   **strikes**: A DOUBLE vector indicating the strike prices.

-   **vols**: A DOUBLE vector indicating the volatilities corresponding to *strikes*\(of the same length\).

-   **curveParams**: A DICT\(STRING, DOUBLE\) indicating the model parameters for the smile method; only effective when *smileMethod*is "SVI" or "SABR":

    -   smileMethod = 'SVI': Must have the keys: 'a', 'b', 'rho', 'm', 'sigma'

    -   smileMethod = 'SABR':

Must have the keys: 'alpha', 'beta', 'rho', 'nu'

-   **fwd** \(optional \): A DOUBLE scalar indicating the forward value. It is required when *smileMethod*is "SVI" or "SABR".


</td><td>

√

</td></tr><tr><td>

termDates

</td><td>

DATE vector

</td><td>

Term date corresponding to each smile in *volSmiles*.

</td><td>

√

</td></tr><tr><td>

surfaceName

</td><td>

STRING

</td><td>

Surface name

</td><td>

×

</td></tr><tr><td>

currencyPair

</td><td>

STRING

</td><td>

Foreign exchange currency pair. Available options: "EURUSD", "USDCNY", "EURCNY", "GBPCNY", "JPYCNY", "HKDCNY".

 Currency pairs may also use `.` or `/` as separators. For example, "EURUSD" can also be written as "EUR.USD" or "EUR/USD".

</td><td>

√

</td></tr></tbody>
</table>Define a MKTDATA object of FxVolatilitySurface type.

``` {#codeblock_tk1_5sq_ngc}
surf = {
	"surfaceName": "USDCNY",
	"mktDataType": "Surface",
	"surfaceType": "FxVolatilitySurface",
	"version": 0,
	"referenceDate": "2025.08.18",
	"smileMethod": "Linear",
	"termDates": [
		"2025.08.21",
		"2026.08.20"
	],
	"volSmiles":[{"strikes": [6.5,7,7.5],"vols": [0.1,0.1,0.1]},{"strikes": [6.5,7,7.5],"vols": [0.1,0.1,0.1]}],
	"currencyPair": "USDCNY"
}

surfUsdCny = parseMktData(surf)
```

