# parseJsonTable {#parsejsontable}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#topic_ijz_tmx_3zb}

`parseJsonTable(json, [schema], [keyCaseSensitive=true])`

## Arguments {#topic_tpb_wmx_3zb}

**json** is a STRING scalar or vector containing JSON objects. If it is a STRING scalar, it can contain one or more JSON objects. JSON arrays and recursive JSON objects are not supported yet.

**schema** \(optional\) is a table that specifies the column names and types. It can contain the following columns:

<table id="table_ul4_bnx_3zb"><thead><tr><th align="left">

**Column**

</th><th align="left">

**Description**

</th></tr></thead><tbody><tr><td align="left">

name

</td><td align="left">

a string representing the column name

</td></tr><tr><td align="left">

type

</td><td align="left">

a string representing the column type.

</td></tr><tr><td align="left">

format

</td><td align="left">

a string specifying the format of date or time columns.

</td></tr></tbody>
</table>If *schema* is not specified, the function will automatically parse the schema based on the first 10 JSON objects.

**keyCaseSensitive** \(optional\) indicates whether keys are case-sensitive. true \(default\) means case sensitive, false means case insensitive.

## Details {#topic_dwp_3nx_3zb}

Parses JSON objects into an in-memory table. An empty JSON object will parsed as an empty row of the table.

-   When *json* is a string containing multiple JSON objects, each object will be converted to a row in the table.
-   When *json* is a vector of strings, each element will be converted to a row in the table.

## Examples {#topic_f5r_jnx_3zb}

``` {#codeblock_tmf_znx_3zb}
json1='{"ID":1, "NAME":"cc"}{"NAME":"dd"}'
parseJsonTable(json1)
```

|ID|NAME|
|---|----|
|1|cc|
| |dd|

``` {#codeblock_fbp_c4x_3zb}
json2 = '{"col_test":"20190522150407"}'
schemaTB = table(["col_test"] as name, ["DATETIME"] as type, ["yyyyMMddHHmmss"] as format)
parseJsonTable(json2, schemaTB)
```

|col\_test|
|---------|
|2019.05.22T15:04:07|

json is a string containing two JSON objects:

``` {#codeblock_zh3_g4x_3zb}
json3='{"ID":11, "NAME":"dd"}'
schemaTB1 = table(["ID", "NAME", "col_test"] as name, ["INT", "STRING", "DATETIME"] as type, [,,"yyyyMMddHHmmss"] as format)
parseJsonTable(concat([json2,json3]),schemaTB1)
```

|ID|NAME|col\_test|
|---|----|---------|
| | |2019.05.22T15:04:07|
|11|dd| |

json is a STRING vector:

``` {#codeblock_o1l_34x_3zb}
parseJsonTable([json2,json3],schemaTB1)
```

|ID|NAME|col\_test|
|---|----|---------|
| | |2019.05.22T15:04:07|
|11|dd| |

