# panel {#panel}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`panel(row, col, metrics, [rowLabel], [colLabel], [parallel=false])`

## Arguments {#arguments}

**row** is a vector. Each element corresponds to a row in a matrix in the result.

**col** is a vector. Each element corresponds to a column in a matrix in the result.

**metrics** is one or multiple vectors. Each vector in metrics corresponds to a matrix in the result.

**rowLabel** is a vector of row labels for the matrix \(or matrices\) in the result. It is composed of distinct values in ascending order. The result only includes the rows specified in *rowLabel*.

**colLabel** is a vector of column labels for the matrix \(or matrices\) in the result. It is composed of distinct values in ascending order. The result only includes the columns specified in *colLabel*.

**parallel** is a Boolean value indicating whether to conduct parallel computing. The default value is false.

## Details {#details}

Rearrange *metrics* as a matrix \(or multiple matrices\). For each vector in *metrics*, return a matrix.

Function `panel` is similar to SQL [pivotBy](../../Programming/SQLStatements/pivotBy.md) clause in that they can both rearrange data as a matrix based on 2 dimensions. The difference is that `exec... pivot by...` can only convert one column into a matrix whereas function `panel` can convert one or multiple columns into one or multiple matrices.

## Examples {#examples}

```
t = table(1 1 2 2 2 3 3 as id, 2020.09.01 + 1 3 1 2 3 2 3 as date, 1..7 as value);
t;
```

|id|date|value|
|---|----|-----|
|1|2020.09.02|1|
|1|2020.09.04|2|
|2|2020.09.02|3|
|2|2020.09.03|4|
|2|2020.09.04|5|
|3|2020.09.03|6|
|3|2020.09.04|7|

```
panel(t.date, t.id, t.value);
```

||1|2|3|
|---|---|---|---|
|2020.09.02|1|3||
|2020.09.03||4|6|
|2020.09.04|2|5|7|

```
panel(t.date, t.id, t.value, 2020.09.02 2020.09.03, 1 2);
```

||1|2|
|---|---|---|
|2020.09.02|1|3|
|2020.09.03||4|

```
panel(t.date, t.id, [t.value, t.value>0], 2020.09.02 2020.09.03, 1 2);
```

||1|2|
|---|---|---|
|2020.09.02|1|3|
|2020.09.03||4|

||1|2|
|---|---|---|
|2020.09.02|1|1|
|2020.09.03||1|

Calculate the cumulative maximum price of each stock from the matrix generated by function `panel`.

```
syms = "sym"+string(1..2)
dates = 2021.12.07..2021.12.11
t = table(loop(take{, size(syms)}, dates).flatten() as trade_date,  take(syms, size(syms)*size(dates)) as code, rand(1000, (size(syms)*size(dates))) as volume)
volume = panel(t.trade_date, t.code, t.volume, dates)
cummax(volume)
```

