# objs {#objs}

## Syntax {#syntax}

`objs([shared=false])`

## Arguments {#arguments}

**shared** is Boolean variable.

-   false \(default\): return info on all variables in the current session

-   true: return info on all variables in the current session and variables shared by other sessions


## Details {#details}

Obtain the information on the variables in memory. Return a table with the following columns:

-   name: variable name

-   type: data type

-   form: data form

-   rows:

    -   If the data form is vector/dictionary/set, return the number of all elements \(including null values\);

    -   If the data form is matrix/table, return the number of rows.

-   columns:

    -   If the data form is vector/dictionary/set, return 1;

    -   If the data form is matrix/table, return the number of columns.

-   bytes: the memory \(in bytes\) used by the variable

-   shared: whether it is a shared variable

-   extra: the logical path to the DFS table, in the format of "dfs://dbName/tableName"

-   owner: the creator of shared variables. This column will only be displayed when *shared* is set to true. It will be left empty for local variables.


Please note that the function does not return the function definitions. You can use defs to check function definitions, or [memSize](../m/memSize.md) for the memory usage.

## Examples {#examples}

```
//create a DFS database
if(existsDatabase("dfs://listdb")){
        dropDatabase("dfs://listdb")
}
n=1000000
ticker = rand(`MSFT`GOOG`FB`ORCL`IBM,n);
ticker[0..5]
x=rand(1.0, n)
t=table(ticker, x)
db=database(directory="dfs://listdb", partitionType=HASH, partitionScheme=[STRING, 5])
pt=db.createPartitionedTable(t, `pt, `ticker)
pt.append!(t)

// shared in-memory table
time = take(2021.08.20 00:00:00..2021.08.30 00:00:00, 40);
id = 0..39;
value = rand(100, 40);
tmp = table(time, id, value);
share tmp as st

// create set
s = set([1,2,3,4,5])

// create dict
x=1 2 3
y=4.5 7.8 4.3
z=dict(x,y);

// create matrix
m = matrix(1 2 3, 4 5 6)

// create pair
p = 1:2
```

```
objs(true)
```

|name|type|form|rows|columns|bytes|shared|extra|owner|
|----|----|----|----|-------|-----|------|-----|-----|
|n|INT|SCALAR|1|1|16|false|||
|ticker|SYMBOL|VECTOR|1,000,000|1|4,000,000|false|||
|x|INT|VECTOR|3|1|12|false|||
|t|BASIC|TABLE|1,000,000|2|12,000,312|false|||
|db|HANDLE|SCALAR|1|1|24|false|||
|pt|ALIAS|TABLE|0|2|12,000,000|false|dfs://listdb/pt||
|time|DATETIME|VECTOR|40|1|160|false|||
|id|INT|VECTOR|40|1|160|false|||
|value|INT|VECTOR|40|1|160|false|||
|tmp|BASIC|TABLE|40|3|832|false|||
|s|INT|SET|5|1|28|false|||
|y|DOUBLE|VECTOR|3|1|24|false|||
|z|DOUBLE|DICTIONARY|3|1|199|false|||
|m|INT|MATRIX|3|2|24|false|||
|p|INT|PAIR|2|1|8|false|||
|st|BASIC|TABLE|40|3|832|true||admin|

