# objectChecksum {#objectchecksum}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`objectChecksum(vector, [prev])`

## Arguments {#arguments}

**vector** is a vector that is used for calculating checksums.

**prev** is an integer. If the vector is too long, the checksum can be computed iteratively by specifying *prev* which represents the checksum of the previous segment of data during iteration.

## Details {#details}

Calculate the checksum of a vector. The result is an integer. It is often used to verify data integrity.

## Examples {#examples}

```
print objectChecksum(take(`A`B`C, 10))
// output: -268298654

print objectChecksum(2.3 6.5 7.8)
// output: -430996932

//calculate checksum section by section
print objectChecksum(1..15)
// output: -1877567753

t0 = objectChecksum(1..5)
t1 = objectChecksum(6..10, t0)
t2 = objectChecksum(11..15, t1)
print t2
// output: -1877567753
```

