# objByName {#objbyname}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`objByName(name, [sharedVar])`

## Arguments {#arguments}

**name** is a string indicating a table name.

**sharedVar** is a Boolean value.

## Details {#details}

DolphinDB parses script before execution. The parsing procedure checks if a variable has been defined locally. If not, it will throw an exception. Assume we execute a locally defined function at remote nodes and the function queries a shared table that exists at remote nodes but not at the local node. If we directly call the table name in SQL statements, the system will fail to parse.

To address this issue, we introduce function `objByName` which returns an object by name at runtime.

If *sharedVar* is not specified, the system searches in local variables before searching in shared variables. If *sharedVar* = true, the system only searches in shared variables; if *sharedVar* = false, the system only searches in local variables.

## Examples {#examples}

At the local node we have a table EarningsDates with 2 columns: *TICKER* and *date*. *date* is the earning announcement date. There is a table USPrices at a remote node with machine name "localhost" and port number 8081. It contains daily stock prices for all US stocks. We would like to get the stock prices from the remote node for all stocks in EarningsDates for the week after they announced earnings.

At the remote node, we import the data file to create the table USPrices, and then share it across all nodes as sharedUSPrices.

```
USPrices = loadText("c:/DolphinDB/Data/USPrices.csv")
share USPrices as sharedUSPrices;
```

At the local node, we create the table EarningsDates, and send the table with the script over to the remote node. After the execution, the result is sent back to the local node.

```
EarningsDates=table(`XOM`AAPL`IBM as TICKER, 2006.10.26 2006.10.19 2006.10.17 as date)
def loadDailyPrice(data){
   dateDict = dict(data.TICKER, data.date)
   return select date, TICKER, PRC from objByName("sharedUSPrices") where dateDict[TICKER]<date<=dateDict[TICKER]+7
}
conn = xdb("localhost",8081)
prices = conn(loadDailyPrice, EarningsDates);

prices;
```

|date|TICKER|PRC|
|----|------|---|
|2006.10.27|XOM|71.46|
|2006.10.30|XOM|70.84|
|2006.10.31|XOM|71.42|
|2006.11.01|XOM|71.06|
|2006.11.02|XOM|71.19|
|2006.10.18|IBM|89.82|
|2006.10.19|IBM|89.86|
|2006.10.20|IBM|90.48|
|2006.10.23|IBM|91.56|
|2006.10.24|IBM|91.49|
|2006.10.20|AAPL|79.95|
|2006.10.23|AAPL|81.46|
|2006.10.24|AAPL|81.05|
|2006.10.25|AAPL|81.68|
|2006.10.26|AAPL|82.19|

