# oauthLogin {#oauthLogin}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`oauthLogin(oauthType, params)`

## Arguments {#arguments}

**oauthType** is a string specifying the grant type of OAuth SSO. It can be:

-   'authentication code'

-   'implicit'

-   'client credentials'


**params** is a dictionary specifying the parameters for authorization.

-   If *oauthType* is set to 'authentication code', *params* should be \{ code:string \}, e.g., `{"code":"9d823075cb151201925a"}`.

-   If *oauthType* is set to 'implicit', *params* should be \{ token\_type:string, access\_token:string, expires\_in?:string \}, e.g., `{token_type: "Bearer", access_token: "MTQ0NjJkZmQ5OTM2NDE1ZTZjNGZmZjI3", expires_in?: "3600"}`.

-   If *oauthType* is set to 'client credentials',*params* should be \{ … \}, e.g., `{&client_id=xxxxxxxxxx&client_secret=xxxxxxxxxx}`.


## Details {#details}

The `oauthLogin` function sends a login request to the specified authorization server based on the input grant type and parameters. DolphinDB currently supports three grant types of OAuth SSO: authentication code grant \(for Web interface\), implicit grant \(for Web interface\), and client credentials grant \(for APIs\).

**Return value**: Token and user information in strings.

## Examples {#examples}

The following example specifies the grant type as 'authentication code' and sets *params* accordingly:

``` {#codeblock_gsw_525_fdc}
oauthLogin("authorization code",{"code":"9d823075cb151201925a"})
```

**Related information**: [Single Sign-On](../../Database/Configuration/reference.md#).

