# nunique {#nunique}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`nunique(X, [ignoreNull=false])`

## Arguments {#arguments}

**X** is a vector/array vector or a tuple composed of multiple vectors with same length.

**ignoreNull** \(optional\) is a Boolean value. If set to true, only non-null elements will be included in the calculation. The default value is false. Note that if *X* is a tuple or array vector, *ignoreNull* must be set to false.

## Details {#details}

If *X* is a vector/array vector, return the number of unique elements in *X*.

If *X* is a tuple, elements of each vector at the same position forms a key, and this function returns the number of unique keys.

## Examples {#examples}

```
v = [1,3,1,-6,NULL,2,NULL,1];
nunique(v);
// output: 5

// set ignoreNull=true
nunique(v,true);
// output: 4
```

``` {#codeblock_ht1_tww_3zb}
a = array(INT[], 0, 10).append!([1 2 3, 3 5, 6 8 8, 9 10])
nunique(a)
// output: 8
```

```
t=table(1 2 4 8 4 2 7 1 as id, 10 20 40 80 40 20 70 10 as val);
select nunique([id,val]) from t;
```

|nunique|
|-------|
|5|

```
dbName = "dfs://testdb"
if(existsDatabase(dbName)){
   dropDatabase(dbName)
}

db=database("dfs://testdb", VALUE, 2012.01.11..2012.01.29)

n=100
t=table(take(2012.01.11..2012.01.29, n) as date, symbol(take("A"+string(21..60), n)) as sym, take(100, n) as val)

pt=db.createPartitionedTable(t, `pt, `date).append!(t)
select nunique(date) from pt group by sym
```

``` {#codeblock_mgz_vww_3zb}
dbName = "dfs://testdb"
if(existsDatabase(dbName)){
dropDatabase(dbName)
}

db=database("dfs://testdb", VALUE, 2012.01.11..2012.01.29)

n=100
t=table(take(2012.01.11..2012.01.29, n) as date, symbol(take("A"+string(21..60), n)) as sym, take(100, n) as val)

pt=db.createPartitionedTable(t, `pt, `date).append!(t)
select nunique(date) from pt group by sym
```

