# notLike {#notlike}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`notLike(X, pattern)`

## Arguments {#arguments}

**X** is a STRING scalar/vector.

**pattern** is a string, usually containing wildcards \(e.g., "%"\).

## Details {#details}

This function checks whether *X* does not match the pattern specified by *pattern*. The comparison is case-sensitive.

**Return value**: A Boolean scalar or vector.

## Examples {#examples}

``` {#codeblock_zq1_tms_c2c}
notLike(`DEFG, `DE);
// output: true

notLike(`DEFG, "%DE%");
// output: false


a=`IBM`ibm`MSFT`Goog;
notLike(a, "%OO%");
// output: [true,true,true,true]

print a[notLike(a, "%OO%")];
// output: ["IBM","ibm","MSFT","Goog"]
```

`notLike` can be used with SQL SELECT to exclude records matching certain conditions:

``` {#codeblock_k3d_hb1_d2c}
t = table(`abb`aac`aaa as sym, 1.8 2.3 3.7 as price);
select * from t where sym notLike "%aa%";
```

|sym|price|
|---|-----|
|abb|1.8|

`notLike`can also be applied to queries on DFS tables:

``` {#codeblock_b2j_3b1_d2c}

dbName="dfs://database1"
if(existsDatabase(dbName)){
	dropDatabase(dbName)
}
db=database(dbName,VALUE,2019.01.01..2019.01.03)
n=100
datetime=take(2019.01.01 +0..100,n)
sym = take(`C`MS`MS`MS`IBM`IBM`IBM`C`C$SYMBOL,n)
price= take(49.6 29.46 29.52 30.02 174.97 175.23 50.76 50.32 51.29,n)
qty = take(2200 1900 2100 3200 6800 5400 1300 2500 8800,n)
t=table(datetime, sym, price, qty)
trades=db.createPartitionedTable(t,`trades,`datetime).append!(t)

select * from trades where sym notLike "%IBM%"
```

Releated function: [like](../l/like.md)

