# nextState {#nextstate}

## Syntax {#syntax}

`nextState(X)`

## Arguments {#arguments}

**X** is a vector or matrix of temporal/Boolean/numeric type.

## Details {#details}

Consecutive elements in *X* with the same value feature the same state, and a null value has no state. The state of each element is equal to its value. Return the next state of the current state for each element in *X*. If it is null, return the next adjacent state.

If *X* is a matrix, return the next state for each column of the matrix.

## Examples {#examples}

```
X = [1, 2.2, NULL, 2.2, 2.3, 1, 1.2]
next(X)
// output: [2.2,,2.2,2.3,1,1.2,]

nextState(X)
// output: [2.2,2.2,2.2,2.3,1,1.2,]

X = matrix([1.0, 1.1, 1.0, 0.9], [NULL, 1.3, 2.5, 5.5], [5.5, 4.2, 1.6, 1.8])
nextState(X)
```

|\#0|\#1|\#2|
|---|---|---|
|1.1|1.3|4.2|
|1|2.5|1.6|
|0.9|5.5|1.8|
||||

Related function: [prevState](../p/prevState.md)

