# neg {#neg}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`neg(X)`

## Arguments {#arguments}

**X** is a scalar/pair/vector/matrix.

Though `neg` and the `-` operator often serve analogous purposes, precedence behavior differs:

-   The `neg` function, when parenthesized carries the highest priority, e.g., neg\(3\) + 5 is -3 + 5. Without parentheses, `neg` has lower precedence than the following expression, e.g., neg 3 + 5 is treated as -\(3 + 5\) resulting -8.

-   The `-` operator always follows the precedence rule. For example: -3 + 5 results in 2.


## Details {#details}

Return the negative of *X*.

## Examples {#examples}

```
x=1:2;
-x;
// output: -1 : -2

x=1 0 1;
-x;
// output: [-1,0,-1]
```

```
m=1 1 1 0 0 0 $ 2:3;
m;
```

|\#0|\#1|\#2|
|---|---|---|
|1|1|0|
|1|0|0|

```
-m
```

|\#0|\#1|\#2|
|---|---|---|
|-1|-1|0|
|-1|0|0|

