# nanInfFill {#naninffill}

## Syntax {#section_rgl_sjz_czb .section}

`nanInfFill(X,Y)`

## Arguments {#section_avs_sjz_czb .section}

`X` is a floating-point number of any data form except for set.

`Y` is a floating-point number.

## Details {#section_rn1_tjz_czb .section}

In DolphinDB, NaN and Inf values of floating-point numbers are replaced with null values. Nan and Inf values can arise in the course of data import, or during calculations involving external data sources.

This function replaces the NaN/Inf value in *X* with the specified *Y*.

**Note:**

When *X* is a dictionary, only dictionary values are replaced.

## Examples {#section_omh_tjz_czb .section}

``` {#codeblock_ygx_wjz_czb}
x = [float(`inf), 2, 3, float(`nan), 5, 6, 7]
nanInfFill (x, 2.2)

x = matrix(1..3, [float(`inf), float(`nan), 1.0])
nanInfFill(x, 1.2)
```

Related functions: [isNanInf](../i/isNanInf.md), [countNanInf](../c/countNanInf.md)

**Parent topic:**[Functions](../../Functions/category.md)

