# mwavg {#mwavg}

## Syntax {#syntax}

`mwavg(Y, X, window, [minPeriods])`

Please see [mFunctions](../Themes/mFunctions.md) for the parameters and windowing logic.

## Details {#details}

Calculate the moving averages of *X* with *Y* as weights in a sliding window.

**Note:**

Different from `mavg` that is based on a window of size \(weight\) length, `mwavg` must use *X* and *Y* of the same length.

The weights in a rolling window are automatically adjusted so that the sum of weights for all non-null elements in the rolling window is 1.

## Examples {#examples}

Function `mwavg` can be used to calculate VWAP \(volume-weighted average price\):

```
price=2.1 2.2 2.3 2.5 2.6 2.8 2.7 2.5;
volume=10 20 10 40 10 40 10 20;
mwavg(price, volume, 4);
// output: [,,,2.35,2.4125,2.61,2.65,2.6875]

mwavg(price, volume, 4, 2);
// output: [,2.166667,2.2,2.35,2.4125,2.61,2.65,2.6875]
```

```
price1 = indexedSeries(date(2020.06.05)+1..8, price)
volume1 = indexedSeries(date(2020.06.05)+1..8, volume)
mwavg(price1,volume1, 4d)
```

|label|col1|
|-----|----|
|2020.06.06|2.1|
|2020.06.07|2.1667|
|2020.06.08|2.2|
|2020.06.09|2.35|
|2020.06.10|2.4125|
|2020.06.11|2.61|
|2020.06.12|2.65|
|2020.06.13|2.6875|

```
mwavg(price1,volume1, 1w)
```

|label|col1|
|-----|----|
|2020.06.06|2.1|
|2020.06.07|2.1667|
|2020.06.08|2.2|
|2020.06.09|2.35|
|2020.06.10|2.3788|
|2020.06.11|2.5077|
|2020.06.12|2.5214|
|2020.06.13|2.5467|

Related functions: [wavg](../w/wavg.md), [mavg](mavg.md).

