# mvarTopN {#mvartopn}

## Syntax {#syntax}

`mvarTopN(X, S, window, top, [ascending=true], [tiesMethod='oldest'])`

Please see [mTopN](../Themes/mTopN.md) for the parameters and windowing logic.

## Details {#details}

Within a sliding window of given length \(measured by the number of elements\), the function stably sorts *X* by *S* in the order specified by *ascending*, then calculates the unbiased sample variance of the first *top* elements.

## Examples {#examples}

```
X = 1..7
S = 0.3 0.5 0.1 0.1 0.5 0.2 0.4
mvarTopN(X, S, 4, 2)
// output: [,0.5,2,0.5,0.5,0.5,2]

X = NULL 1 2 3 4 NULL 5
S = 3 5 1 1 5 2 4
mvarTopN(X, S, 4, 2)
// output: [,,,0.5,0.5,0.5,]

X = matrix(1..5, 6..10)
S = 2022.01.01 2022.02.03 2022.01.23 2022.04.06 2021.12.29
mvarTopN(X, S, 3, 2)
```

|\#0|\#1|
|---|---|
|||
|0.5|0.5|
|2|2|
|0.5|0.5|
|2|2|

```
X = matrix(1..5, 6..10)
S = matrix(2022.01.01 2022.02.03 2022.01.23 NULL 2021.12.29,NULL 2022.02.03 2022.01.23 2022.04.06 NULL)
mvarTopN(X, S, 3, 2)
```

|\#0|\#1|
|---|---|
|||
|0.5||
|2|0.5|
|0.5|0.5|
|2|0.5|

Related function: [mvar](mvar.md)

