# mul {#mul}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`mul(X, Y)` or `X*Y`

## Arguments {#arguments}

**X** and **Y** is a scalar/pair/vector/matrix. If one of *X* and *Y* is a pair/vector/matrix, the other must be a scalar or a pair/vector/matrix of the same size.

## Details {#details}

Return the element-by-element product of *X* and *Y*.

## Examples {#examples}

```
1:2*3;
// output: 3 : 6

1:2*3:4;
// output: 3 : 8

x=1 2 3;
x * 2;
// output: [2,4,6]

y=4 5 6;
x * y;
// output: [4,10,18]
```

```
m1=1..6$2:3;
m1;
```

|\#0|\#1|\#2|
|---|---|---|
|1|3|5|
|2|4|6|

```
m1*2;
```

|\#0|\#1|\#2|
|---|---|---|
|2|6|10|
|4|8|12|

```
m2=6..1$2:3;
m2;
```

|\#0|\#1|\#2|
|---|---|---|
|6|4|2|
|5|3|1|

```
m1*m2;
```

|\#0|\#1|\#2|
|---|---|---|
|6|12|10|
|10|12|6|

