# msum2 {#msum2}

## Syntax {#syntax}

`msum2(X, window, [minPeriods])`

Please see [mFunctions](../Themes/mFunctions.md) for the parameters and windowing logic.

## Details {#details}

Calculate the sum of squares of all elements of *X* in a sliding window \(based on the number of elements or time\). Please note that the return is always of DOUBLE type.

## Examples {#examples}

```
X = 2 1 3 7 6 5 4
Y = 2 1 3 NULL 6 5 4

msum2(X, 3)
// output: [,,14,59,94,110,77]

msum2(Y, 3)
// output: [,,14,10,45,61,77]

msum2(Y, 3, minPeriods=1)
// output: [4,5,14,10,45,61,77]

m = matrix(1 NULL 4 NULL 8 6 , 9 NULL NULL 10 NULL 2)
m.rename!(date(2021.08.16)+1..6, `col1`col2)
m.setIndexedMatrix!()
msum2(m, 3d)  // equivalent to msum2(m, 3)
```

|label|col1|col2|
|-----|----|----|
|2021.08.17|1|81|
|2021.08.18|1|81|
|2021.08.19|17|81|
|2021.08.20|16|100|
|2021.08.21|80|100|
|2021.08.22|100|104|

Related functions: [sum2](../s/sum2.md)

