# mstdpTopN {#mstdptopn}

## Syntax {#syntax}

`mstdpTopN(X, S, window, top, [ascending=true], [tiesMethod='oldest'])`

Please see [mTopN](../Themes/mTopN.md) for the parameters and windowing logic.

## Details {#details}

Within a sliding window of given length \(measured by the number of elements\), the function stably sorts *X* by *S* in the order specified by *ascending*, then calculates the population standard deviation of the first *top* elements.

## Examples {#examples}

```
X = 1..7
S = 0.3 0.5 0.1 0.1 0.5 0.2 0.4
mstdTopN(X, S, 4, 2)
// output: [,0.707106781186548,1.414213562373095,0.707106781186548,0.707106781186548,0.707106781186548,1.414213562373095]

X = NULL 1 2 3 4 NULL 5
S = 3 5 1 1 5 2 4
mstdTopN(X, S, 4, 2)
// output: [,,,0.707106781186548,0.707106781186548,0.707106781186548,]

X = matrix(1..5, 6..10)
S = 2022.01.01 2022.02.03 2022.01.23 2022.04.06 2021.12.29
mstdTopN(X, S, 3, 2)
```

|\#0|\#1|
|---|---|
| | |
|0.707106781186548|0.707106781186548|
|1.414213562373095|1.414213562373095|
|0.707106781186548|0.707106781186548|
|1.414213562373095|1.414213562373095|

```
X = matrix(1..5, 6..10)
S = matrix(2022.01.01 2022.02.03 2022.01.23 NULL 2021.12.29,NULL 2022.02.03 2022.01.23 2022.04.06 NULL)
mstdpTopN(X, S, 3, 2)
```

|\#0|\#1|
|---|---|
| | |
|0.7071| |
|1.4142|0.7071|
|0.7071|0.7071|
|1.4142|0.7071|

Related function: [mstdp](mstdp.md)

