# mrank {#mrank}

## Syntax {#syntax}

`mrank(X, ascending, window, [ignoreNA=true], [tiesMethod='min'], [percent=false], [minPeriods])`

Please see [mFunctions](../Themes/mFunctions.md) for the parameters and windowing logic.

## Arguments {#arguments}

**ascending** is a Boolean value indicating whether the sorting direction is ascending.

**ignoreNA** is a Boolean value indicating whether null values are ignored in ranking. The default value is true. If null values participate in the ranking, they are ranked the lowest.

**tiesMethod** is a string indicating how to rank the group of records with the same value \(i.e., ties\):

-   'min': lowest rank of the group

-   'max': highest rank of the group

-   'average': average rank of the group


**percent** is a Boolean value, indicating whether to display the returned rankings in percentile form. The default value is false.

## Details {#details}

Return the rank of each element of *X* in a sliding window.

## Examples {#examples}

```
X = 3 2 4 4 4 NULL 1

mrank(X, ascending=false, window=3, ignoreNA=true);
// output: [,,0,0,0,,1]

mrank(X, ascending=false, window=3, ignoreNA=true, minPeriods=2);
// output: [,1,0,0,0,,1]

mrank(X, ascending=false, window=3, ignoreNA=false, tiesMethod='max');
// output: [,,0,1,2,2,1]

mrank(X, ascending=false, window=3, ignoreNA=false, tiesMethod='max', minPeriods=2);
// output: [,1,0,1,2,2,1]

mrank(X, ascending=false, window=3, ignoreNA=false, tiesMethod='min');
// output: [,,0,0,0,2,1]

mrank(X, ascending=false, window=3, ignoreNA=false, tiesMethod='min', minPeriods=3);
// output: [,,0,0,0,,]

mrank(X, ascending=false, window=3, ignoreNA=false, tiesMethod='average');
// output: [,,0,0.5,1,2,1]

mrank(X, ascending=false, window=3, ignoreNA=false, tiesMethod='average', minPeriods=2);
// output: [,1,0,0.5,1,2,1]
```

```
m=matrix(1 2 5 3 4, 5 4 1 2 3);
m;
```

|\#0|\#1|
|---|---|
|1|5|
|2|4|
|5|1|
|3|2|
|4|3|

```
mrank(m, true, 3);
```

|\#0|\#1|
|---|---|
|||
|||
|2|0|
|1|1|
|1|2|

```
mrank(m, true, 3, percent=true);
```

|\#0|\#1|
|---|---|
|||
|||
|1|0.3333|
|0.6667|0.6667|
|0.6667|1|

When window is the time offset of DURATION type:

```
m=matrix([1 4 2 4 5 7 4 3 2 5])
m.rename!(2020.01.01..2020.01.10, [`A])
m.setIndexedMatrix!()
mrank(m, window=3d, percent = 1)
```

|label|A|
|-----|---|
|2020.01.01|1|
|2020.01.02|1|
|2020.01.03|0.6667|
|2020.01.04|0.6667|
|2020.01.05|1|
|2020.01.06|1|
|2020.01.07|0.3333|
|2020.01.08|0.3333|
|2020.01.09|0.3333|
|2020.01.10|1|

```
mrank(m, window=1w, percent = 1)
```

|label|A|
|-----|---|
|2020.01.01|1|
|2020.01.02|1|
|2020.01.03|0.6667|
|2020.01.04|0.75|
|2020.01.05|1|
|2020.01.06|1|
|2020.01.07|0.4286|
|2020.01.08|0.2857|
|2020.01.09|0.1429|
|2020.01.10|0.7143|

Related functions: [rank](../r/rank.md)

