# mprod {#mprod}

## Syntax {#syntax}

`mprod(X, window, [minPeriods])`

Please see [mFunctions](../Themes/mFunctions.md) for the parameters and windowing logic.

## Details {#details}

Calculate the moving products of *X* in a sliding window.

## Examples {#examples}

```
X = 2 1 3 7 6 5 4
Y = 2 1 3 NULL 6 5 4

mprod(X, 3);
// output: [,,6,21,126,210,120]

mprod(Y, 3);
// output: [,,6,3,18,30,120]

mprod(Y, 3, minPeriods=1);
// output: [2,2,6,3,18,30,120]
```

```
m=matrix(1 NULL 4 NULL 8 6 , 9 NULL NULL 10 NULL 2)
m.rename!(date(2020.04.06)+1..6, `col1`col2)
m.setIndexedMatrix!()
mprod(m, 3d)
```

|label|col1|col2|
|-----|----|----|
|2020.04.07|1|9|
|2020.04.08|1|9|
|2020.04.09|4|9|
|2020.04.10|4|10|
|2020.04.11|32|10|
|2020.04.12|48|20|

```
mprod(m, 1w)
```

|label|col1|col2|
|-----|----|----|
|2020.04.07|1|9|
|2020.04.08|1|9|
|2020.04.09|4|9|
|2020.04.10|4|90|
|2020.04.11|32|90|
|2020.04.12|192|180|

Related functions: [prod](../p/prod.md)

