# mpercentile {#mpercentile}

## Syntax {#syntax}

`mpercentile(X, percent, window, [interpolation='linear'], [minPeriods])`

Please see [mFunctions](../Themes/mFunctions.md) for the parameters and windowing logic.

## Arguments {#arguments}

**percent** is an integer or floating value between 0 and 100.

**interpolation** is a string indicating the interpolation method to use if the specified percentile is between two elements in *X* \(assuming the ith and \(i+1\)th element in the sorted *X*\) . It can take the following values:

-   'linear': Return ![](../../images/linear.png), where ![](../../images/fraction.png)

-   'lower': Return ![](../../images/lower.png)

-   'higher': Return ![](../../images/higher.png)

-   'nearest': Return ![](../../images/nearest.png) that is closest to the specified percentile

-   'midpoint': Return ![](../../images/midpoint.png)


The default value of *interpolation* is 'linear'.

**minPeriods** is a positive integer indicating the minimum number of observations in a window required to be not null \(otherwise the result is NULL\).

## Details {#details}

Return the percentile rank of each element of *X* in a sliding window.

## Examples {#examples}

```
x=2 1 3 7 6 5 4;
mpercentile(x, percent=50, window=3);
// output: [,,2,3,6,6,5]

mpercentile(x, percent=25, window=3, interpolation="lower");
// output: [,,1,1,3,5,4]

mpercentile(x, percent=75, window=3, interpolation="higher")
// output: [,,3,7,7,7,6]

mpercentile(x, percent=5, window=3, interpolation="nearest")
// output: [,,1,1,3,5,4]

mpercentile(x, percent=15, window=3, interpolation="midpoint")
// output: [,,1.5,2,4.5,5.5,4.5]

mpercentile(x, percent=50, window=3, interpolation="linear", minPeriods=1);
// output: [2,1.5,2,3,6,6,5]

m=matrix(2 1 3 7 6 5 4, 1..7);
m;
```

|\#0|\#1|
|---|---|
|2|1|
|1|2|
|3|3|
|7|4|
|6|5|
|5|6|
|4|7|

```
mpercentile(m, percent=50, window=3, interpolation="linear", minPeriods=1);
```

|\#0|\#1|
|---|---|
|2|1|
|1.5|1.5|
|2|2|
|3|3|
|6|4|
|6|5|
|5|6|

```
m.rename!(date(2020.09.08)+1..7, `A`B)
m.setIndexedMatrix!()
mpercentile(m, percent=50, window=3d, interpolation="linear", minPeriods=1);
```

|label|col1|col2|
|-----|----|----|
|2020.09.09|2|1|
|2020.09.10|1.5|1.5|
|2020.09.11|2|2|
|2020.09.12|3|3|
|2020.09.13|6|4|
|2020.09.14|6|5|
|2020.09.15|5|6|

```
mpercentile(m, percent=50, window=1w, interpolation="linear", minPeriods=1);
```

|label|col1|col2|
|-----|----|----|
|2020.09.09|2|1|
|2020.09.10|1.5|1.5|
|2020.09.11|2|2|
|2020.09.12|2.5|2.5|
|2020.09.13|3|3|
|2020.09.14|4|3.5|
|2020.09.15|4|4|

Related functions: [percentile](../p/percentile.md)

