# movingWindowData {#movingwindowdata}

## Syntax {#section_qcz_j11_dzb .section}

`movingWindowData(X, window, [fixed=false])`

## Arguments {#section_syk_k11_dzb .section}

`X` is a vector.

`window` is an integer greater than or equal to 2. It indicates the size of a count-based window.

`fixed` is a Boolean specifying whether the size of each row of the result must be fixed to *window*. When *fixed*=true, the missing elements in the first \(window-1\) windows are filled with null values. The default value is false.

## Details {#section_v5b_l11_dzb .section}

Return an array vector where each row indicates the elements of a window sliding over *X*.

## Examples {#section_cdr_l11_dzb .section}

``` {#codeblock_s5h_m11_dzb}
S = -1 3 -4 0 5 10 9 7
 m = movingWindowData(X=S,window=3);
 m;
// output: [[-1],[-1,3],[-1,3,-4],[3,-4,0],[-4,0,5],[0,5,10],[5,10,9],[10,9,7]]

mi = movingWindowData(X=S,window=3,fixed=true);
mi;
// output: [[00i,00i,-1],[00i,-1,3],[-1,3,-4],[3,-4,0],[-4,0,5],[0,5,10],[5,10,9],[10,9,7]]
    
// get the value of the first element in each window
m[0]
// output: [-1,-1,-1,3,-4,0,5,10]

mi[0]
// output: [,,-1,3,-4,0,5,10]

//Get the data with a sliding window of length 5 in the reactive state engine
n = 100
DateTime = 2023.01.01T09:00:00 + rand(10000, n).sort!()
SecurityID = take(`600021`600022`600023`600024`600025, n)
Price = 1.0 + rand(1.0, n) 
t = table(1:0, `DateTime`SecurityID`Price, [TIMESTAMP, SYMBOL, DOUBLE])
tableInsert(t, DateTime, SecurityID, Price)
output = table(100:0, `SecurityID`DateTime`PriceNew, [SYMBOL, DATETIME, DOUBLE[]])

engine = createReactiveStateEngine(name="rseEngine", metrics=[<DateTime>, <movingWindowData(Price,5)>], dummyTable=t, outputTable=output, keyColumn=`SecurityID, keepOrder=true)
engine.append!(t)
dropStreamEngine(`rseEngine)
```

**Parent topic:**[Functions](../../Functions/category.md)

