# movingTopNIndex {#movingtopnindex}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`movingTopNIndex(X, window, top, [ascending=true], [fixed=false], [tiesMethod='oldest'])`

## Arguments {#arguments}

**X** is a numeric/temporal vector. Note: Starting from version 2.00.10, the null values in X do not participate in data sorting.

**window** is an integer no less than 2, indicating the window size.

**top** is an integer greater than 1 and no greater than *window*.

**ascending** is a Boolean value indicating whether the data within a window is sorted in ascending order. True means ascending order and false means descending order.

**fixed** is a Boolean value, indicating whether the length of each row in the output array vector is fixed to be *top*. The default value is false. When *fixed* = true, all rows are of the same length. For the first \(*top* - 1\) windows, the indices of missing elements are replaced with null values.

**tiesMethod** is a string that specifies how to select elements if there are more elements with the same value than spots available in the top N after sorting *X* within a sliding window. It can be:

-   'oldest': select elements starting from the earliest entry into the window;

-   'latest': select elements starting from the latest entry into the window.


## Details {#details}

Return an array vector indicating the indices of the first *top* elements of *X* after sorted within each sliding window.

## Examples {#examples}

```
S = 2 5 6 1 2 4 5 6 9 0
m1 = movingTopNIndex(X=S, window=4, top=2, ascending=true, fixed=true)
m1;
// output: [[00i,0],[0,1],[0,1],[3,0],[3,4],[3,4],[3,4],[4,5],[5,6],[9,6]]

m2 = movingTopNIndex(X=S, window=4, top=2, ascending=false, fixed=true)
m2;
// output: [[00i,0],[1,0],[2,1],[2,1],[2,1],[2,5],[6,5],[7,6],[8,7],[8,7]]

m3 = movingTopNIndex(X=S, window=4, top=2, ascending=true, fixed=false)
print m3;
// output: [[0],[0,1],[0,1],[3,0],[3,4],[3,4],[3,4],[4,5],[5,6],[9,6]]

S[m1[0]]
// output: [,2,2,1,1,1,1,2,4,0]

S[m3[0]]
// output: [2,2,2,1,1,1,1,2,4,0]
```

```
X = [5, 8, 1, 9, 7, 3, 1, NULL, 0, 8, 7, 7]
movingTopNIndex(X=X, window=4, top=2, ascending=true, fixed=true)
// Before version 2.00.10, the null values in X are involved in data sorting.
// output: [[00i,0],[0,1],[2,0],[2,0],[2,4],[2,5],[6,5],[7,6],[7,8],[7,8],[7,8],[8,10]]
// As of version 2.00.10, the null values in X are ignored in data sorting.
// output: [[00i,0],[0,1],[2,0],[2,0],[2,4],[2,5],[6,5],[6,5],[8,6],[8,6],[8,10],[8,10]]

X = [2, 1, 4, 3, 4, 3, 4]
// For the sixth window, the sorted X is 1 2 3 3 4 4.
// As tiesMethod is not specified, the default 'oldest' is used, meaning the first occurrence of 3 (at index 3) is selected.
movingTopNIndex(X,6,3)
// output: [[0],[1,0],[1,0,2],[1,0,3],[1,0,3],[1,0,3],[1,3,5]]]

// As tiesMethod is set to 'latest', the latest occurrence of 3 (at index 5) is selected.
movingTopNIndex(X,6,3,tiesMethod="latest")
// output: [[0],[1,0],[1,0,2],[1,0,3],[1,0,3],[1,0,5],[1,3,5]]
```

