# move {#move}

## Syntax {#syntax}

`move(X, steps)`

## Arguments {#arguments}

**X** is a vector/matrix/table.

**steps** is an integer indicating how many positions to shift the elements of *X*.

-   If *steps* is positive, *X* is moved to the right for *steps* positions;
-   If *steps* is negative, *X* is moved to the left for *steps* positions;
-   If *steps* is 0, *X* does not move;
-   If *steps* is a DURATION, *X* must be an indexed matrix or indexed series with temporal values as its row index.

## Details {#details}

`move` is the general form of [prev](../p/prev.md) and [next](../n/next.md).

## Examples {#examples}

```
x=3 9 5 1 4 9;
move(x,3);
// output: [,,,3,9,5]

move(x,-2);
// output: [5,1,4,9,,]

index = (second(08:20:00)+1..4) join 08:21:01 join 08:21:02
x = index.indexedSeries(x)
move(x,3s)
```

|label|col1|
|-----|----|
|08:20:01| |
|08:20:02| |
|08:20:03| |
|08:20:04|3|
|08:21:01|1|
|08:21:02|1|

``` {#pre_ltn_y5z_hzb}
move(x,1m)
```

|label|col1|
|-----|----|
|08:20:01| |
|08:20:02| |
|08:20:03| |
|08:20:04| |
|08:21:01|3|
|08:21:02|9|

