# monthOfYear {#monthofyear}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`monthOfYear(X)`

## Arguments {#arguments}

**X** is a scalar/vector of type DATE, MONTH, DATETIME, TIMESTAMP or NANOTIMESTAMP.

## Details {#details}

For each element in *X*, return a number from 1 to 12 indicating which month of the year it falls in.

## Examples {#examples}

```
monthOfYear(2012.07.02);
// output: 7

monthOfYear([2012.06.12T12:30:00,2012.10.28T12:35:00,2013.01.06T12:36:47,2013.04.06T08:02:14]);
// output: [6,10,1,4]
```

Related functions: [dayOfYear](../d/dayOfYear.md), [dayOfMonth](../d/dayOfMonth.md), [quarterOfYear](../q/quarterOfYear.md), [weekOfYear](../w/weekOfYear.md), [hourOfDay](../h/hourOfDay.md), [minuteOfHour](minuteOfHour.md), [secondOfMinute](../s/secondOfMinute.md), [millisecond](millisecond.md), [microsecond](microsecond.md), [nanosecond](../n/nanosecond.md)

