# mmse {#mmse}

## Syntax {#syntax}

`mmse(Y, X, window, [minPeriods])`

Please see [mFunctions](../Themes/mFunctions.md) for windowing logic.

## Arguments {#topic_yv2_xt4_3bc}

**Y** is a vector indicating the dependent variable.

**X** is a vector indicating the independent variable.

**window** is an integer no smaller than 2 or a scalar of DURATION type indicating the size of the sliding window. Note: The window size is capped at 102400 when m-functions are used in the streaming engines.

**minPeriods** \(optional\) is a positive integer indicating the minimum number of observations in a window required to be not null \(otherwise the result is NULL\).

## Details {#details}

Return the coefficient estimates of *X* and mean square errors of an ordinary-least-squares regression of *Y* on *X* with intercept with a rolling window. The length of the window is given by the parameter *window*.

The mean square error \(MSE\) is calculated with the following formula:

![](../../images/mmse.png)

The result is a tuple with 2 vectors. The first vector is the coefficient estimates and the second vector is the mean square errors. Each vector is of the same length as *X* and *Y*.

## Examples {#examples}

```
x=0.011 0.006 -0.008 0.012 -0.016 -0.023 0.018
y=0.016 0.009 -0.012 0.022 0.003 -0.056 0.002;

mmse(y, x, 5)[0];
// output: [,,,,0.818182,1.692379,1.188532]

mmse(y, x, 5)[1];
// output: [,,,,0.000055,0.000231,0.000332]

select y, x, mmse(y,x,5,3) as `mbeta`mmse from table(x,y);
```

|y|x|mbeta|mmse|
|---|---|-----|----|
|0.016|0.011|||
|0.009|0.006|||
|-0.012|-0.008|1.479381|2.806415E-8|
|0.022|0.012|1.594701|0.000003|
|0.003|-0.016|0.818182|0.000055|
|-0.056|-0.023|1.692379|0.000231|
|0.002|0.018|1.188532|0.000332|

