# mmed {#mmed}

## Syntax {#syntax}

`mmed(X, window, [minPeriods])`

Please see [mFunctions](../Themes/mFunctions.md) for the parameters and windowing logic.

## Details {#details}

Calculate the moving median of *X* in a sliding window.

## Examples {#examples}

```
X = 2 1 3 7 6 5 4
Y = 2 1 3 NULL 6 5 4

mmed(X, 3);
// output: [,,2,3,6,6,5]

mmed(Y, 3);
// output: [,,2,2,4.5,5.5,5]

mmed(Y, 3, minPeriods=1);
// output: [2,1.5,2,2,4.5,5.5,5]
```

```
m = matrix(1 5 9 0 2, 9 10 2 NULL 2)
m.rename!(date(2020.09.08)+1..5, `A`B)
m.setIndexedMatrix!()
m.mmed(3d)
```

|label|col1|col2|
|-----|----|----|
|2020.09.09|1|9|
|2020.09.10|3|9.5|
|2020.09.11|5|9|
|2020.09.12|5|6|
|2020.09.13|2|2|

```
m.mmed(1w)
```

|label|col1|col2|
|-----|----|----|
|2020.09.09|1|9|
|2020.09.10|3|9.5|
|2020.09.11|5|9|
|2020.09.12|3|9|
|2020.09.13|2|5.5|

Related functions: [med](med.md)

