# mmaxPositiveStreak {#mmaxpositivestreak}

## Syntax {#syntax}

`mmaxPositiveStreak(X, window)`

Please see [mFunctions](../Themes/mFunctions.md) for the parameters and windowing logic.

## Details {#details}

Obtain the maximum value of the sum of consecutive positive numbers in *X* within a sliding window of given size \(based on the number of elements\).

## Examples {#examples}

```
x = 1 -1 1 -2 10 3 3 9 0 6 5
w = 5
mmaxPositiveStreak(x, w)
// output: [,,,,10,13,16,25,25,15,12]

x = 5 NULL 3 2 1 5 10 9 NULL 9 10 -1 NULL
w = 5
mmaxPositiveStreak(x, w)
// output: [,,,,6,11,21,27,25,24,19,19,19]

// use the signum function to count the maximum number of consecutive positive numbers
mmaxPositiveStreak(signum(x), w)
// output: [,,,,3,4,5,5,4,3,2,2,2]
```

