# mkurtosisTopN {#mkurtosistopn}

## Syntax {#syntax}

`mkurtosisTopN(X, S, window, top, [biased=true], [ascending=true], [tiesMethod='latest'])`

Please see [mTopN](../Themes/mTopN.md) for the parameters and windowing logic.

## Arguments {#arguments}

**biased** \(optional\) is a Boolean value indicating whether the result is biased. The default value is true, meaning the bias is not corrected.

## Details {#details}

Within a sliding window of given length \(measured by the number of elements\), the function stably sorts *X* by *S* in the order specified by *ascending*, then calculates the moving kurtosis of the first *top* elements.

**Return value**: DOUBLE type

## Examples {#examples}

```
X=1 2 3 10 100 4 3
S = 0.3 0.5 0.1 0.1 0.5 0.2 0.4
mkurtosisTopN(X, S, 6, 4)
// output: [,,1.49,2.23,2.31,2.11,2.27]

X = matrix(1..10, 11..20)
S = matrix(2022.01.01 2022.02.03 2022.01.23 NULL 2021.12.29 2022.01.20 2022.01.23 2022.01.22 2022.01.24 2022.01.24, NULL 2022.02.03 2022.01.23 2022.04.06 NULL 2022.02.03 2022.02.03 2022.02.05 2022.02.08 2022.02.03)
mkurtosisTopN(X, S, 6, 4)

/* output:
col1   col2


1.5
1.5    1.5
1.8457 1.5
1.5734 1.8457
1.8457 1.2215
1.64   2
1.64   1.64
1.64   1.8457
*/

symbol = ["A","A","A","B","A","A","B","A","A","B","B","B","A","B","A","B","B","A","B","A"]
time = temporalAdd(2023.07.05T09:30:00.000,[10,20,40,60,70,80,90,140,160,170,180,190,200,210,220,230,250,360,390,400],"ms")
price = [28.11,28.25,28.44,52.31,28.98,28.89,52.22,28.16,28.52,52.62,52.56,52.2,28.01,52.43,28.57,52.42,52.19,28.16,52.84,28.18]
qty = [5000,400,3100,100,2400,3700,700,3700,4600,4700,3100,3300,3900,3500,3000,3000,4000,4700,2000,4400]
BSFlag = [1,0,0,0,1,1,0,1,0,0,0,1,0,0,1,1,1,0,1,0]
t = table(time, symbol, price, qty, BSFlag)
select time,symbol,mkurtosisTopN(price, qty, 8, 5) as mskewTop5price from t context by symbol
```

|time|symbol|mskewTop5price|
|----|------|--------------|
|2023.07.05T09:30:00.010|A||
|2023.07.05T09:30:00.020|A||
|2023.07.05T09:30:00.040|A|1.5|
|2023.07.05T09:30:00.070|A|2.0147|
|2023.07.05T09:30:00.080|A|1.3355|
|2023.07.05T09:30:00.140|A|1.2976|
|2023.07.05T09:30:00.160|A|1.2976|
|2023.07.05T09:30:00.200|A|1.2976|
|2023.07.05T09:30:00.220|A|2.2021|
|2023.07.05T09:30:00.360|A|1.656|
|2023.07.05T09:30:00.400|A|1.351|
|2023.07.05T09:30:00.060|B||
|2023.07.05T09:30:00.090|B||
|2023.07.05T09:30:00.170|B|1.5|
|2023.07.05T09:30:00.180|B|1.1993|
|2023.07.05T09:30:00.190|B|1.289|
|2023.07.05T09:30:00.210|B|1.7383|
|2023.07.05T09:30:00.230|B|1.8183|
|2023.07.05T09:30:00.250|B|1.8183|
|2023.07.05T09:30:00.390|B|1.923|

Related function: [mkurtosis](mkurtosis.md)

