# miminLast {#miminlast}

## Syntax {#syntax}

`miminLast(X, window, [minPeriods])`

## Arguments {#arguments}

Please see [mFunctions](../Themes/mFunctions.dita) for the parameters and windowing logic.

## Details {#details}

Return the position of the element with the smallest value in *X* in a sliding window. If there are multiple elements with the identical smallest value in a window, return the position of the first element from the right. Same as other aggregate functions, null values are ignored.

## Examples {#examples}

``` {#codeblock_qkx_qj3_d1c}
x = 1.2 2 NULL -1 6 -1
$miminLast(x,3);
// output: [,,0,2,1,2]
```

``` {#codeblock_ojd_gmh_3bc}
m=matrix(3 2 2 4 2, 1 4 2 1 3);
miminLast(m,3)
```

|\#0|\#1|
|---|---|
|||
|||
|2|0|
|1|2|
|2|1|

``` {#codeblock_ilj_b1b_3bc}
t=table(3 2 2 as c1, 1 1 4 as c2)
miminLast(t,3)
```

|\#0|\#1|
|---|---|
|||
|||
|2|1|

``` {#codeblock_ucg_rz1_3bc}
x = [NULL, 2, NULL, NULL, 3.2]
date = [0, 1, 3,  8, 9] + 2020.01.01
X = indexedSeries(date, x) 
miminLast(X, 3d)
```

| |\#0|
|---|---|
|2020.01.01|-1|
|2020.01.02|1|
|2020.01.04|0|
|2020.01.09|-1|
|2020.01.10|1|

Related function: [mimin](mimin.md)

