# milastNot {#milastnot}

## Syntax {#syntax}

`milastNot(X, window, [minPeriods])`

Please see [mFunctions](../Themes/mFunctions.md) for the parameters and windowing logic.

## Details {#details}

Return the index of the last non-null element of *X* in a sliding window \(based on the number of elements or time\).

## Examples {#examples}

```
v = NULL NULL 2 3 4 8 NULL 5 -2 3 -1 0 NULL
milastNot(v, 3)
// output: [,,2,2,2,2,1,2,2,2,2,2,1]

m = matrix(1 2 3 NULL, 1 2 NULL 3, 1 3 NULL NULL, 1 2 3 4)
milastNot(m, 2)
```

|\#0|\#1|\#2|\#3|
|---|---|---|---|
|||||
|1|1|1|1|
|1|0|0|1|
|0|1|-1|1|

``` {#codeblock_r4h_n3d_gbc}
T = [2022.01.01, 2022.01.02, 2022.01.03, 2022.01.06, 2022.01.07]
X = NULL 2 NULL 4 5
X1 = indexedSeries(T, X)
milastNot(X1, 2, 1)
```

| |\#0|
|---|---|
|2022.01.01|-1|
|2022.01.02|1|
|2022.01.03|0|
|2022.01.06|0|
|2022.01.07|1|

Related function: [mifirstNot](mifirstNot.md)

